package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.utils.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.YsqqXmxxSegydz;
import com.ruoyi.project.ys.service.IYsqqXmxxSegydzService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * segy文件标注Controller
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@RestController
@RequestMapping("/ysqqXmxxSegydz/segydz")
public class YsqqXmxxSegydzController extends BaseController
{
    @Autowired
    private IYsqqXmxxSegydzService ysqqXmxxSegydzService;

    /**
     * 查询segy文件标注列表
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegydz:segydz:list')")
    @GetMapping("/list")
    public TableDataInfo list(YsqqXmxxSegydz ysqqXmxxSegydz)
    {
        startPage();
        List<YsqqXmxxSegydz> list = ysqqXmxxSegydzService.selectYsqqXmxxSegydzList(ysqqXmxxSegydz);
        return getDataTable(list);
    }

    @GetMapping("/getList")
    public TableDataInfo getList(YsqqXmxxSegydz ysqqXmxxSegydz)
    {
//        startPage();
        List<YsqqXmxxSegydz> list = ysqqXmxxSegydzService.selectYsqqXmxxSegydzList(ysqqXmxxSegydz);
        return getDataTable(list);
    }

    /**
     * 导出segy文件标注列表
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegydz:segydz:export')")
    @Log(title = "segy文件标注", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, YsqqXmxxSegydz ysqqXmxxSegydz)
    {
        List<YsqqXmxxSegydz> list = ysqqXmxxSegydzService.selectYsqqXmxxSegydzList(ysqqXmxxSegydz);
        ExcelUtil<YsqqXmxxSegydz> util = new ExcelUtil<YsqqXmxxSegydz>(YsqqXmxxSegydz.class);
        util.exportExcel(response, list, "segy文件标注数据");
    }

    /**
     * 获取segy文件标注详细信息
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegydz:segydz:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ysqqXmxxSegydzService.selectYsqqXmxxSegydzById(id));
    }

    /**
     * 新增segy文件标注
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegydz:segydz:add')")
    @Log(title = "segy文件标注", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody YsqqXmxxSegydz ysqqXmxxSegydz)
    {
        return toAjax(ysqqXmxxSegydzService.insertYsqqXmxxSegydz(ysqqXmxxSegydz));
    }

    /**
     * 修改segy文件标注
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegydz:segydz:edit')")
    @Log(title = "segy文件标注", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody YsqqXmxxSegydz ysqqXmxxSegydz)
    {
        return toAjax(ysqqXmxxSegydzService.updateYsqqXmxxSegydz(ysqqXmxxSegydz));
    }

    /**
     * 删除segy文件标注
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegydz:segydz:remove')")
    @Log(title = "segy文件标注", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ysqqXmxxSegydzService.deleteYsqqXmxxSegydzByIds(ids));
    }


    @PostMapping("/addAll")
    public AjaxResult addAll(@RequestBody YsqqXmxxSegydz ysqqXmxxSegydz)
    {
        List<YsqqXmxxSegydz> list = ysqqXmxxSegydz.getList();
        if(list.size()==0){
            return AjaxResult.error("数据不能为空！");
        }
        return toAjax(ysqqXmxxSegydzService.addAll(ysqqXmxxSegydz));
    }
}
