package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.YsqqXmxxJxx;
import com.ruoyi.project.ys.service.IYsqqXmxxJxxService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 验收前期-项目信息-井信息Controller
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@RestController
@RequestMapping("/ysqqXmxxJxx/jxx")
public class YsqqXmxxJxxController extends BaseController
{
    @Autowired
    private IYsqqXmxxJxxService ysqqXmxxJxxService;

    /**
     * 查询验收前期-项目信息-井信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(YsqqXmxxJxx ysqqXmxxJxx)
    {
        startPage();
        List<YsqqXmxxJxx> list = ysqqXmxxJxxService.selectYsqqXmxxJxxList(ysqqXmxxJxx);
        return getDataTable(list);
    }

    /**
     * 导出验收前期-项目信息-井信息列表
     */
    @Log(title = "验收前期-项目信息-井信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, YsqqXmxxJxx ysqqXmxxJxx)
    {
        List<YsqqXmxxJxx> list = ysqqXmxxJxxService.selectYsqqXmxxJxxList(ysqqXmxxJxx);
        ExcelUtil<YsqqXmxxJxx> util = new ExcelUtil<YsqqXmxxJxx>(YsqqXmxxJxx.class);
        util.exportExcel(response, list, "验收前期-项目信息-井信息数据");
    }

    /**
     * 获取验收前期-项目信息-井信息详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ysqqXmxxJxxService.selectYsqqXmxxJxxById(id));
    }

    /**
     * 新增验收前期-项目信息-井信息
     */
    @Log(title = "验收前期-项目信息-井信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody YsqqXmxxJxx ysqqXmxxJxx)
    {
        return toAjax(ysqqXmxxJxxService.insertYsqqXmxxJxx(ysqqXmxxJxx));
    }

    /**
     * 修改验收前期-项目信息-井信息
     */
    @Log(title = "验收前期-项目信息-井信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody YsqqXmxxJxx ysqqXmxxJxx)
    {
        return toAjax(ysqqXmxxJxxService.updateYsqqXmxxJxx(ysqqXmxxJxx));
    }

    /**
     * 删除验收前期-项目信息-井信息
     */
    @Log(title = "验收前期-项目信息-井信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ysqqXmxxJxxService.deleteYsqqXmxxJxxByIds(ids));
    }
}
