package com.ruoyi.project.dz.utils;

import org.apache.commons.io.IOUtils;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

//import org.sinoprobe.util.Util4JavaBean;
/**
 * segy数据文件读取类
 * 它包括了对segy文件所包含全部数据对象的封装
 * 
 * @author dingyi
 *
 */
public class SegyReader {
	
	private String filePath;
	private SegyTextFileHeader txtHdr;
	private SegyReelHdr reelHdr;
	private ArrayList<SegyTrace> traceList=new ArrayList<SegyTrace>();
	

	/**
	 * 构造Segy读取对象
	 * @param filePath  segy文件名，包括全路径
	 */
	public SegyReader(String filePath) {
		super();
		this.filePath = filePath;
	}

	public SegyTextFileHeader getFileHeader3200 () throws IOException, SegyFileFormatException {
        FileInputStream fis = new FileInputStream(filePath);
        DataInputStream dis = new DataInputStream(fis);
        // 首先读取前3200字节的文本头
        byte[] buf = new byte[3200];
        dis.readFully(buf);
        byte[] b = CodeUtil.EBCDICToASCII(buf);
        txtHdr = new SegyTextFileHeader(b);

        return txtHdr;
    }
	
	public void buildFromFile() throws IOException, SegyFileFormatException{

		FileInputStream fis = new FileInputStream(filePath);
		DataInputStream dis = new DataInputStream(fis);
		// 首先读取前3200字节的文本头
		byte[] buf = new byte[3200];
		dis.readFully(buf);
		byte[] b = CodeUtil.EBCDICToASCII(buf);
		txtHdr = new SegyTextFileHeader(b);
		//判断是否合法，即是否每一行均以C开头，如果不合法，那么，可能会是存在带头标签
//		if(!txtHdr.isValid()){
//			throw new SegyFileFormatException("卷头数据不是以C开头，可能存在标签对象，请尝试用另外方法读取！");
//		}

		//继续读取卷头数据
		buf = new byte[400];
		dis.readFully(buf);
		reelHdr = new SegyReelHdr(buf);
		//判断是否有扩展卷头
		if(reelHdr.has_extend_text_hdr_flag!=0){
			//此时有3200字节的扩展原文文件头
			//需要执行读取动作，此处暂空，以抛出异常为处理手段
			throw new SegyFileFormatException("存在扩展原文文件头，需要读取！");
		}

        dis.close();
        fis.close();
        outFile(filePath);
		//测试
//        SegyTextFileHeader txtHdr2 = SegyReadUtil.getFileHeader3200(filePath);
//        SegyReelHdr reelHdr2 = SegyReadUtil.getFileHeader400(filePath);
//        SegyTrace tttrace = SegyReadUtil.getOneTraceByNo(filePath, 187, 855, txtHdr, reelHdr);
//        SegyTrace tttrace2 = SegyReadUtil.getOneTraceByNo(filePath, 187, 859, txtHdr, reelHdr);
//        SegyTrace tttrace3 = SegyReadUtil.getOneTraceByNo(filePath, 188, 1225, txtHdr, reelHdr);
//        SegyTrace tttrace4 = SegyReadUtil.getOneTraceByNo(filePath, 207, 1228, txtHdr, reelHdr);
//        soutTrace(tttrace);
//        soutTrace(tttrace2);
//        soutTrace(tttrace3);
//        soutTrace(tttrace4);
		//继续读取道数据
		//强制读取卷头所标记的
	//for (int i = 0; i <reelHdr.traces_per_record; i++)
//		while(dis.available()>0) {
//			// 首先读取道头
//			buf = new byte[240];
//			dis.readFully(buf);
//			SegyTrace oneTrace = new SegyTrace(buf);
//			// 根据卷头和道头得出要读取的数据块的大小
//			int dataCount = oneTrace.samples_in_this_trace * reelHdr.getMultiple();
//			//读取道数据
//			buf = new byte[dataCount];
//			dis.readFully(buf);
//			oneTrace.readDataInIBMFormat(buf);
//			//添加到道列表中
//			traceList.add(oneTrace);
//            System.out.println("序号：" + traceList.size() + "  测线中道顺序号：" + oneTrace.trace_sequence_number_within_line
//                    + "  野外原始记录号：" + oneTrace.original_field_record_number
//                    + "  道集号：" + oneTrace.cdp_ensemble_number
//                    //+ "  道集的道数：" + oneTrace.trace_sequence_number_within_cdp_ensemble
//                    + "  该道采样点数：" + oneTrace.samples_in_this_trace
//                    + "  该道采样间隔：" + oneTrace.sample_intervall
//                    + "  震源坐标――X：" + oneTrace.x_source_coordinate
//                    + "  震源坐标――Y：" + oneTrace.y_source_coordinate
//                    //+ "  真实坐标值的因子：" + oneTrace.scalar_for_coordinates
//                    //+ "  产生该道的垂直叠加道数：" + oneTrace.number_of_vertically_summed_traces_yielding_this_trace
//                    //+ "  产生该道的水平叠加道数：" + oneTrace.number_of_horizontally_stacked_traced_yielding_this_trace
//            );
//        }
//		System.out.println("读取道数据结束");

		dis.close();
		fis.close();

	}


	/**
	 * 得到原文文件头，文本格式
	 * @return
	 */
	public SegyTextFileHeader getTxtHdr() {
		return txtHdr;
	}

	/**
	 * 得到卷（道集）头数据
	 * @return
	 */
	public SegyReelHdr getReelHdr() {
		return reelHdr;
	}

	/**
	 * 得到道数据列表
	 * @return
	 */
	public ArrayList<SegyTrace> getTraceList() {
		return traceList;
	}
	/**
	 * 得到测量到的最大最小值
	 * @return  顺序为min，Max
	 */
	public double[] getMinMaxValue(){
		double[] minMax=new double[2];
		minMax[0]=0;
		minMax[1]=0;
		for(SegyTrace t:traceList){
			for(double d: t.data){
				if(d>minMax[1])
					minMax[1]=d;
				if(d<minMax[0])
					minMax[0]=d;
			}
		}
		return minMax;
	}
	public static void main(String[] args) {
//		SegyReader reader=new SegyReader("D:\\SoftWork\\2023-06-05 物地震\\地震2\\dy-sgy_dongyingdongbuall_3d_pstm2.Sgy");
		SegyReader reader=new SegyReader("D:\\SoftWork\\2023-06-05 物地震\\地震\\1-VPVS.Sgy");
		try {
			reader.buildFromFile();
			System.out.println("数据读取完成！开始构造vtk显示");
			
//			//构造vtk界面
//			 final SimpleVTK2 vtkPanel=new SimpleVTK2(reader);
//			 SwingUtilities.invokeLater(new Runnable() {
//		            @Override
//		            public void run() {
//		                JFrame frame = new JFrame("SimpleVTK");
//		                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
//		                frame.getContentPane().setLayout(new BorderLayout());
//		                frame.getContentPane().add(vtkPanel);
//		                frame.setSize(640, 480);
//		                frame.setLocationRelativeTo(null);
//		                frame.setVisible(true);
//		            }
//		        });
//

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SegyFileFormatException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}



	public void soutTrace(SegyTrace oneTrace){
        System.out.println("序号：" //+ traceList.size()
                        + "  测线中道顺序号：" + oneTrace.trace_sequence_number_within_line
                        + "  野外原始记录号：" + oneTrace.original_field_record_number
                        + "  道集号：" + oneTrace.cdp_ensemble_number
                        //+ "  道集的道数：" + oneTrace.trace_sequence_number_within_cdp_ensemble
                        + "  该道采样点数：" + oneTrace.samples_in_this_trace
                        + "  该道采样间隔：" + oneTrace.sample_intervall
                        + "  震源坐标――X：" + oneTrace.x_source_coordinate
                        + "  震源坐标――Y：" + oneTrace.y_source_coordinate
                //+ "  真实坐标值的因子：" + oneTrace.scalar_for_coordinates
                //+ "  产生该道的垂直叠加道数：" + oneTrace.number_of_vertically_summed_traces_yielding_this_trace
                //+ "  产生该道的水平叠加道数：" + oneTrace.number_of_horizontally_stacked_traced_yielding_this_trace
        );
    }

    public void outFile(String filePath) throws IOException, SegyFileFormatException {
        System.out.println("读取头文件");
        FileInputStream fis = new FileInputStream(filePath);
        DataInputStream dis = new DataInputStream(fis);
        byte[] buf = new byte[3600];
        dis.readFully(buf);

        System.out.println("读取前端选点列表");
        List<Point> points = new ArrayList<>();
        Point p = new Point();
        p.setX(187); p.setY(1000);points.add(p);p = new Point();
        p.setX(1026);p.setY(1000);points.add(p);p = new Point();
        p.setX(687); p.setY(855); points.add(p);p = new Point();
        p.setX(687); p.setY(1228);points.add(p);
        System.out.println(points);

        if (points.size()>=2) {
            for (int i = 0; i < points.size()-1; i++) {
                Point nw = points.get(i);
                Point nx = points.get(i+1);
                System.out.println("坐标点 : (" + nw.getX() + ", " + nw.getY() + ") 与 (" + nx.getX() + ", " + nx.getY() + ")之间的点：");
                List<Point> lp = CoordinateUtil.getPointBetweenTwo(nw.getX(), nw.getY(), nx.getX(), nx.getY());
                for (int j = 0; j < lp.size(); j++) {
                    Point pp = lp.get(j);
                    System.out.println("坐标点 " + i + ": (" + pp.getX() + ", " + pp.getY() + ")");
                    byte[] tttrace = SegyReadUtil.getOneTraceByteByNo(filePath, pp.getX(), pp.getY(), txtHdr, reelHdr);
                    buf = SegyReadUtil.byteMerger(buf, tttrace);
                }
            }
        }

//        byte[] tttrace = SegyReadUtil.getOneTraceByteByNo(filePath, 187, 855, txtHdr, reelHdr);
//        byte[] all = SegyReadUtil.byteMerger(buf, tttrace);
//        byte[] tttrace2 = SegyReadUtil.getOneTraceByteByNo(filePath, 187, 859, txtHdr, reelHdr);
//        all = SegyReadUtil.byteMerger(all, tttrace2);
//        byte[] tttrace3 = SegyReadUtil.getOneTraceByteByNo(filePath, 188, 1225, txtHdr, reelHdr);
//        all = SegyReadUtil.byteMerger(all, tttrace3);
//        byte[] tttrace4 = SegyReadUtil.getOneTraceByteByNo(filePath, 207, 1228, txtHdr, reelHdr);
//        all = SegyReadUtil.byteMerger(all, tttrace4);
//
        FileOutputStream fos = null;
        String pathName = "D:\\SoftWork\\2023-06-05 物地震\\地震\\temp.Sgy";
        File file = new File(pathName);
        fos = new FileOutputStream(file);
        fos.write(buf);
        IOUtils.close(fos);
    }
}
