package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.YscgZllx;
import com.ruoyi.project.ys.service.IYscgZllxService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 资料类型Controller
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@RestController
@RequestMapping("/yscgZllx/zllx")
public class YscgZllxController extends BaseController
{
    @Autowired
    private IYscgZllxService yscgZllxService;

    /**
     * 查询资料类型列表
     */
    @PreAuthorize("@ss.hasPermi('yscgZllx:zllx:list')")
    @GetMapping("/list")
    public TableDataInfo list(YscgZllx yscgZllx)
    {
        startPage();
        List<YscgZllx> list = yscgZllxService.selectYscgZllxList(yscgZllx);
        return getDataTable(list);
    }

    /**
     * 导出资料类型列表
     */
    @PreAuthorize("@ss.hasPermi('yscgZllx:zllx:export')")
    @Log(title = "资料类型", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, YscgZllx yscgZllx)
    {
        List<YscgZllx> list = yscgZllxService.selectYscgZllxList(yscgZllx);
        ExcelUtil<YscgZllx> util = new ExcelUtil<YscgZllx>(YscgZllx.class);
        util.exportExcel(response, list, "资料类型数据");
    }

    /**
     * 获取资料类型详细信息
     */
    @PreAuthorize("@ss.hasPermi('yscgZllx:zllx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(yscgZllxService.selectYscgZllxById(id));
    }

    /**
     * 新增资料类型
     */
    @PreAuthorize("@ss.hasPermi('yscgZllx:zllx:add')")
    @Log(title = "资料类型", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody YscgZllx yscgZllx)
    {
        return toAjax(yscgZllxService.insertYscgZllx(yscgZllx));
    }

    /**
     * 修改资料类型
     */
    @PreAuthorize("@ss.hasPermi('yscgZllx:zllx:edit')")
    @Log(title = "资料类型", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody YscgZllx yscgZllx)
    {
        return toAjax(yscgZllxService.updateYscgZllx(yscgZllx));
    }

    /**
     * 删除资料类型
     */
    @PreAuthorize("@ss.hasPermi('yscgZllx:zllx:remove')")
    @Log(title = "资料类型", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(yscgZllxService.deleteYscgZllxByIds(ids));
    }


    /**
     * 查询资料类型列表
     */
    @GetMapping("/selectZllx")
    public TableDataInfo selectZllx(YscgZllx yscgZllx)
    {
        List<YscgZllx> list = yscgZllxService.selectYscgZllxList(yscgZllx);
        return getDataTable(list);
    }
}
