package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.framework.config.RuoYiConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.HyjyxxMapper;
import com.ruoyi.project.ys.domain.Hyjyxx;
import com.ruoyi.project.ys.service.IHyjyxxService;


import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import static com.ruoyi.common.utils.SecurityUtils.getUserId;

/**
 * 会议信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class HyjyxxServiceImpl implements IHyjyxxService 
{
    @Autowired
    private HyjyxxMapper hyjyxxMapper;

    /**
     * 查询会议信息
     * 
     * @param id 会议信息主键
     * @return 会议信息
     */
    @Override
    public Hyjyxx selectHyjyxxById(Long id)
    {
        return hyjyxxMapper.selectHyjyxxById(id);
    }

    /**
     * 查询会议信息列表
     * 
     * @param hyjyxx 会议信息
     * @return 会议信息
     */
    @Override
    public List<Hyjyxx> selectHyjyxxList(Hyjyxx hyjyxx)
    {
        return hyjyxxMapper.selectHyjyxxList(hyjyxx);
    }

    /**
     * 新增会议信息
     * 
     * @param hyjyxx 会议信息
     * @return 结果
     */
    @Override
    public int insertHyjyxx(Hyjyxx hyjyxx)
    {
        hyjyxx.setCreatedBy(getUserId()+"");
        hyjyxx.setCreatedTime(DateUtils.getNowDate());
        return hyjyxxMapper.insertHyjyxx(hyjyxx);
    }

    /**
     * 修改会议信息
     * 
     * @param hyjyxx 会议信息
     * @return 结果
     */
    @Override
    public int updateHyjyxx(Hyjyxx hyjyxx)
    {
        hyjyxx.setUpdateBy(getUserId()+"");
        hyjyxx.setUpdateTime(DateUtils.getNowDate());
        return hyjyxxMapper.updateHyjyxx(hyjyxx);
    }

    /**
     * 批量删除会议信息
     * 
     * @param ids 需要删除的会议信息主键
     * @return 结果
     */
    @Override
    public int deleteHyjyxxByIds(Long[] ids)
    {
        return hyjyxxMapper.deleteHyjyxxByIds(ids);
    }

    /**
     * 删除会议信息信息
     * 
     * @param id 会议信息主键
     * @return 结果
     */
    @Override
    public int deleteHyjyxxById(Long id)
    {
        return hyjyxxMapper.deleteHyjyxxById(id);
    }


    // 1. 转录接口地址（固定）
    private static final String ASR_API_URL = "/asr";
    /**
     * 修改会议信息
     *
     * @param id 会议信息
     * @return 结果
     */
    @Override
    public int hyzl(Long id)
    {
        Hyjyxx hyjyxx =hyjyxxMapper.selectHyjyxxById(id);
        String targetMp3Url = RuoYiConfig.getDzysip() + hyjyxx.getYpwj();
        try {
            // 1. 发送 POST 请求，获取原始 JSON 响应
            String responseJson = sendAsrPostRequest(targetMp3Url);
            System.out.println("接口返回原始 JSON：" + responseJson);

            // 创建ObjectMapper实例
            ObjectMapper objectMapper = new ObjectMapper();

            // 将String转换为JsonNode（JSON对象）
            JsonNode jsonNode = objectMapper.readTree(responseJson);

            // 2. 直接提取 asr_text 和 timestamp_text 的值
            String asrText = jsonNode.get("asr_text").asText();
            String timestampText = jsonNode.get("json_result").toString();
            hyjyxx.setYw(asrText);
            hyjyxx.setYwBzh(timestampText);
            hyjyxx.setJxzt("转录成功");
            return hyjyxxMapper.updateHyjyxx(hyjyxx);
        } catch (IOException e) {
            System.err.println("请求异常：" + e.getMessage());
            e.printStackTrace();
            hyjyxx.setJxzt("转录失败");
            hyjyxxMapper.updateHyjyxx(hyjyxx);
            return 0;
        }
    }


    /**
     * 发送 POST 请求到 ASR 接口
     * @param mp3Url 音频文件 URL（对应请求参数 mp3_url）
     * @return 接口返回结果（Map 格式：key=asr_text/timestamp_text，value=对应文本）
     * @throws IOException 网络异常/请求失败
     */
    public static String sendAsrPostRequest(String mp3Url) throws IOException {
        // 1. 构建请求 JSON 字符串（无实体类，直接拼接）
        String requestJson = String.format("{\"mp3_url\":\"%s\"}", mp3Url);

        // 2. 创建 URL 对象并打开连接
        URL url = new URL(RuoYiConfig.getYpzlip()+ASR_API_URL);
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();

        try {
            // 3. 配置请求参数（POST 方法、请求头、超时时间）
            connection.setRequestMethod("POST"); // 必须设为 POST
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8"); // 声明 JSON 格式
            connection.setDoOutput(true); // 允许向服务器写数据（POST 必须开启）
            connection.setConnectTimeout(5000); // 连接超时：5秒
            connection.setReadTimeout(500000); // 读取响应超时：10秒

            // 4. 向服务器写入请求体（JSON 字符串）
            try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream())) {
                byte[] requestBytes = requestJson.getBytes(StandardCharsets.UTF_8);
                outputStream.write(requestBytes); // 写入请求数据
                outputStream.flush(); // 刷新缓冲区，确保数据全部发送
            }

            // 5. 检查请求是否成功（HTTP 状态码 200-299 为成功）
            int responseCode = connection.getResponseCode();
            if (responseCode < 200 || responseCode >= 300) {
                throw new IOException("请求失败！HTTP 状态码：" + responseCode
                        + "，响应信息：" + connection.getResponseMessage());
            }

            // 6. 读取接口返回的 JSON 响应
            StringBuilder responseSb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(
                    new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    responseSb.append(line); // 逐行读取响应内容
                }
            }
            String responseJson = responseSb.toString();

            // 7. 将 JSON 转为 Map（无实体类，直接通过 key 取值）
            return responseJson;

        } finally {
            // 8. 关闭连接（避免资源泄漏）
            connection.disconnect();
        }
    }



}
