package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.CommunFile;
import com.ruoyi.project.ys.service.ICommunFileService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 公用附件表Controller
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@RestController
@RequestMapping("/communFile/file")
public class CommunFileController extends BaseController
{
    @Autowired
    private ICommunFileService communFileService;

    /**
     * 查询公用附件表列表
     */
    @PreAuthorize("@ss.hasPermi('communFile:file:list')")
    @GetMapping("/list")
    public TableDataInfo list(CommunFile communFile)
    {
        startPage();
        List<CommunFile> list = communFileService.selectCommunFileList(communFile);
        return getDataTable(list);
    }

    /**
     * 导出公用附件表列表
     */
    @PreAuthorize("@ss.hasPermi('communFile:file:export')")
    @Log(title = "公用附件表", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CommunFile communFile)
    {
        List<CommunFile> list = communFileService.selectCommunFileList(communFile);
        ExcelUtil<CommunFile> util = new ExcelUtil<CommunFile>(CommunFile.class);
        util.exportExcel(response, list, "公用附件表数据");
    }

    /**
     * 获取公用附件表详细信息
     */
    @PreAuthorize("@ss.hasPermi('communFile:file:query')")
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        return success(communFileService.selectCommunFileByID(ID));
    }

    /**
     * 新增公用附件表
     */
    @PreAuthorize("@ss.hasPermi('communFile:file:add')")
    @Log(title = "公用附件表", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody CommunFile communFile)
    {
        return toAjax(communFileService.insertCommunFile(communFile));
    }

    /**
     * 修改公用附件表
     */
    @PreAuthorize("@ss.hasPermi('communFile:file:edit')")
    @Log(title = "公用附件表", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CommunFile communFile)
    {
        return toAjax(communFileService.updateCommunFile(communFile));
    }

    /**
     * 删除公用附件表
     */
    @PreAuthorize("@ss.hasPermi('communFile:file:remove')")
    @Log(title = "公用附件表", businessType = BusinessType.DELETE)
	@DeleteMapping("/{IDs}")
    public AjaxResult remove(@PathVariable Long[] IDs)
    {
        return toAjax(communFileService.deleteCommunFileByIDs(IDs));
    }
}
