package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.YsqqXmxxXmcyMapper;
import com.ruoyi.project.ys.domain.YsqqXmxxXmcy;
import com.ruoyi.project.ys.service.IYsqqXmxxXmcyService;

import static com.ruoyi.common.utils.SecurityUtils.getUserId;

/**
 * 验收前期-项目信息-项目成员Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-10-30
 */
@Service
public class YsqqXmxxXmcyServiceImpl implements IYsqqXmxxXmcyService 
{
    @Autowired
    private YsqqXmxxXmcyMapper ysqqXmxxXmcyMapper;

    /**
     * 查询验收前期-项目信息-项目成员
     * 
     * @param cyid 验收前期-项目信息-项目成员主键
     * @return 验收前期-项目信息-项目成员
     */
    @Override
    public YsqqXmxxXmcy selectYsqqXmxxXmcyByCyid(Long cyid)
    {
        return ysqqXmxxXmcyMapper.selectYsqqXmxxXmcyByCyid(cyid);
    }

    /**
     * 查询验收前期-项目信息-项目成员列表
     * 
     * @param ysqqXmxxXmcy 验收前期-项目信息-项目成员
     * @return 验收前期-项目信息-项目成员
     */
    @Override
    public List<YsqqXmxxXmcy> selectYsqqXmxxXmcyList(YsqqXmxxXmcy ysqqXmxxXmcy)
    {
        return ysqqXmxxXmcyMapper.selectYsqqXmxxXmcyList(ysqqXmxxXmcy);
    }

    /**
     * 新增验收前期-项目信息-项目成员
     * 
     * @param ysqqXmxxXmcy 验收前期-项目信息-项目成员
     * @return 结果
     */
    @Override
    public int insertYsqqXmxxXmcy(YsqqXmxxXmcy ysqqXmxxXmcy)
    {
        ysqqXmxxXmcy.setCreatedBy(getUserId()+"");
        ysqqXmxxXmcy.setCreatedTime(DateUtils.getNowDate());
        return ysqqXmxxXmcyMapper.insertYsqqXmxxXmcy(ysqqXmxxXmcy);
    }

    /**
     * 修改验收前期-项目信息-项目成员
     * 
     * @param ysqqXmxxXmcy 验收前期-项目信息-项目成员
     * @return 结果
     */
    @Override
    public int updateYsqqXmxxXmcy(YsqqXmxxXmcy ysqqXmxxXmcy)
    {
        ysqqXmxxXmcy.setUpdateBy(getUserId()+"");
        ysqqXmxxXmcy.setUpdateTime(DateUtils.getNowDate());
        return ysqqXmxxXmcyMapper.updateYsqqXmxxXmcy(ysqqXmxxXmcy);
    }

    /**
     * 批量删除验收前期-项目信息-项目成员
     * 
     * @param cyids 需要删除的验收前期-项目信息-项目成员主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxXmcyByCyids(Long[] cyids)
    {
        return ysqqXmxxXmcyMapper.deleteYsqqXmxxXmcyByCyids(cyids);
    }

    /**
     * 删除验收前期-项目信息-项目成员信息
     * 
     * @param cyid 验收前期-项目信息-项目成员主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxXmcyByCyid(Long cyid)
    {
        return ysqqXmxxXmcyMapper.deleteYsqqXmxxXmcyByCyid(cyid);
    }
}
