package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.YsqqXmxxJxxMapper;
import com.ruoyi.project.ys.domain.YsqqXmxxJxx;
import com.ruoyi.project.ys.service.IYsqqXmxxJxxService;

/**
 * 验收前期-项目信息-井信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class YsqqXmxxJxxServiceImpl implements IYsqqXmxxJxxService 
{
    @Autowired
    private YsqqXmxxJxxMapper ysqqXmxxJxxMapper;

    /**
     * 查询验收前期-项目信息-井信息
     * 
     * @param id 验收前期-项目信息-井信息主键
     * @return 验收前期-项目信息-井信息
     */
    @Override
    public YsqqXmxxJxx selectYsqqXmxxJxxById(Long id)
    {
        return ysqqXmxxJxxMapper.selectYsqqXmxxJxxById(id);
    }

    /**
     * 查询验收前期-项目信息-井信息列表
     * 
     * @param ysqqXmxxJxx 验收前期-项目信息-井信息
     * @return 验收前期-项目信息-井信息
     */
    @Override
    public List<YsqqXmxxJxx> selectYsqqXmxxJxxList(YsqqXmxxJxx ysqqXmxxJxx)
    {
        return ysqqXmxxJxxMapper.selectYsqqXmxxJxxList(ysqqXmxxJxx);
    }

    /**
     * 新增验收前期-项目信息-井信息
     * 
     * @param ysqqXmxxJxx 验收前期-项目信息-井信息
     * @return 结果
     */
    @Override
    public int insertYsqqXmxxJxx(YsqqXmxxJxx ysqqXmxxJxx)
    {
        return ysqqXmxxJxxMapper.insertYsqqXmxxJxx(ysqqXmxxJxx);
    }

    /**
     * 修改验收前期-项目信息-井信息
     * 
     * @param ysqqXmxxJxx 验收前期-项目信息-井信息
     * @return 结果
     */
    @Override
    public int updateYsqqXmxxJxx(YsqqXmxxJxx ysqqXmxxJxx)
    {
        ysqqXmxxJxx.setUpdateTime(DateUtils.getNowDate());
        return ysqqXmxxJxxMapper.updateYsqqXmxxJxx(ysqqXmxxJxx);
    }

    /**
     * 批量删除验收前期-项目信息-井信息
     * 
     * @param ids 需要删除的验收前期-项目信息-井信息主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxJxxByIds(Long[] ids)
    {
        return ysqqXmxxJxxMapper.deleteYsqqXmxxJxxByIds(ids);
    }

    /**
     * 删除验收前期-项目信息-井信息信息
     * 
     * @param id 验收前期-项目信息-井信息主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxJxxById(Long id)
    {
        return ysqqXmxxJxxMapper.deleteYsqqXmxxJxxById(id);
    }
}
