package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.YscgZllxMapper;
import com.ruoyi.project.ys.domain.YscgZllx;
import com.ruoyi.project.ys.service.IYscgZllxService;

/**
 * 资料类型Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class YscgZllxServiceImpl implements IYscgZllxService 
{
    @Autowired
    private YscgZllxMapper yscgZllxMapper;

    /**
     * 查询资料类型
     * 
     * @param id 资料类型主键
     * @return 资料类型
     */
    @Override
    public YscgZllx selectYscgZllxById(Long id)
    {
        return yscgZllxMapper.selectYscgZllxById(id);
    }

    /**
     * 查询资料类型列表
     * 
     * @param yscgZllx 资料类型
     * @return 资料类型
     */
    @Override
    public List<YscgZllx> selectYscgZllxList(YscgZllx yscgZllx)
    {
        return yscgZllxMapper.selectYscgZllxList(yscgZllx);
    }

    /**
     * 新增资料类型
     * 
     * @param yscgZllx 资料类型
     * @return 结果
     */
    @Override
    public int insertYscgZllx(YscgZllx yscgZllx)
    {
        return yscgZllxMapper.insertYscgZllx(yscgZllx);
    }

    /**
     * 修改资料类型
     * 
     * @param yscgZllx 资料类型
     * @return 结果
     */
    @Override
    public int updateYscgZllx(YscgZllx yscgZllx)
    {
        yscgZllx.setUpdateTime(DateUtils.getNowDate());
        return yscgZllxMapper.updateYscgZllx(yscgZllx);
    }

    /**
     * 批量删除资料类型
     * 
     * @param ids 需要删除的资料类型主键
     * @return 结果
     */
    @Override
    public int deleteYscgZllxByIds(Long[] ids)
    {
        return yscgZllxMapper.deleteYscgZllxByIds(ids);
    }

    /**
     * 删除资料类型信息
     * 
     * @param id 资料类型主键
     * @return 结果
     */
    @Override
    public int deleteYscgZllxById(Long id)
    {
        return yscgZllxMapper.deleteYscgZllxById(id);
    }
}
