package com.ruoyi.project.ys.mapper;

import java.util.List;
import com.ruoyi.project.ys.domain.YscgFileRole;

/**
 * 成果单文件权限管理Mapper接口
 * 
 * @author ruoyi
 * @date 2025-10-31
 */
public interface YscgFileRoleMapper 
{
    /**
     * 查询成果单文件权限管理
     * 
     * @param id 成果单文件权限管理主键
     * @return 成果单文件权限管理
     */
    public YscgFileRole selectYscgFileRoleById(Long id);

    /**
     * 查询成果单文件权限管理列表
     * 
     * @param yscgFileRole 成果单文件权限管理
     * @return 成果单文件权限管理集合
     */
    public List<YscgFileRole> selectYscgFileRoleList(YscgFileRole yscgFileRole);

    /**
     * 新增成果单文件权限管理
     * 
     * @param yscgFileRole 成果单文件权限管理
     * @return 结果
     */
    public int insertYscgFileRole(YscgFileRole yscgFileRole);

    /**
     * 修改成果单文件权限管理
     * 
     * @param yscgFileRole 成果单文件权限管理
     * @return 结果
     */
    public int updateYscgFileRole(YscgFileRole yscgFileRole);

    /**
     * 删除成果单文件权限管理
     * 
     * @param id 成果单文件权限管理主键
     * @return 结果
     */
    public int deleteYscgFileRoleById(Long id);

    /**
     * 批量删除成果单文件权限管理
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteYscgFileRoleByIds(Long[] ids);

    /**
     * 批量新增成果单文件权限管理
     *
     * @param yscgFileRoleList 成果单文件权限管理列表
     * @return 结果
     */
    public int batchYscgFileRole(List<YscgFileRole> yscgFileRoleList);
}
