package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.YscgWjscqk;
import com.ruoyi.project.ys.service.IYscgWjscqkService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 成果管理Controller
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@RestController
@RequestMapping("/yscgWjscqk/wjscqk")
public class YscgWjscqkController extends BaseController
{
    @Autowired
    private IYscgWjscqkService yscgWjscqkService;

    /**
     * 查询成果管理列表
     */
    @GetMapping("/list")
    public TableDataInfo list(YscgWjscqk yscgWjscqk)
    {
        startPage();
        List<YscgWjscqk> list = yscgWjscqkService.selectYscgWjscqkList(yscgWjscqk);
        return getDataTable(list);
    }

    /**
     * 导出成果管理列表
     */
    @Log(title = "成果管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, YscgWjscqk yscgWjscqk)
    {
        List<YscgWjscqk> list = yscgWjscqkService.selectYscgWjscqkList(yscgWjscqk);
        ExcelUtil<YscgWjscqk> util = new ExcelUtil<YscgWjscqk>(YscgWjscqk.class);
        util.exportExcel(response, list, "成果管理数据");
    }

    /**
     * 获取成果管理详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(yscgWjscqkService.selectYscgWjscqkById(id));
    }

    /**
     * 新增成果管理
     */
    @Log(title = "成果管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody YscgWjscqk yscgWjscqk)
    {
        return toAjax(yscgWjscqkService.insertYscgWjscqk(yscgWjscqk));
    }

    /**
     * 修改成果管理
     */
    @Log(title = "成果管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody YscgWjscqk yscgWjscqk)
    {
        return toAjax(yscgWjscqkService.updateYscgWjscqk(yscgWjscqk));
    }

    /**
     * 删除成果管理
     */
    @Log(title = "成果管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(yscgWjscqkService.deleteYscgWjscqkByIds(ids));
    }


    /**
     * 查询共享资料列表
     */
    @GetMapping("/list_My")
    public TableDataInfo gxlist(YscgWjscqk yscgWjscqk)
    {
        startPage();
        List<YscgWjscqk> list = yscgWjscqkService.selectYscgWjscqkList_My(yscgWjscqk);
        return getDataTable(list);
    }
}
