import {SeismicColors} from '@int/geotoolkit/seismic/util/SeismicColors';

const colorMapItems = {};
SeismicColors.getDefault().listNameColorMaps().forEach((colorMap) => {
    colorMapItems[colorMap] = SeismicColors.getDefault().createNamedColorMap(colorMap).exportToImage(320, 20).getCanvas().toDataURL();
});

/* eslint-disable max-len */
const uischema = {
    'type': 'Categorization',
    'elements': [
        {
            'type': 'Category',
            'label': 'Scale',
            'elements': [
                {
                    'type': 'Group',
                    'label': 'Scaling',
                    'elements': [
                        {
                            'type': 'HorizontalLayout',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Traces per inch',
                                    'scope': '#/properties/scale/properties/tracescale'
                                },
                                {
                                    'type': 'Control',
                                    'label': 'Inches per second',
                                    'scope': '#/properties/scale/properties/samplescale'
                                }
                            ]
                        }
                    ]
                },
                {
                    'type': 'Group',
                    'label': 'Interpolation',
                    'elements': [
                        {
                            'type': 'HorizontalLayout',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Samples interpolation type',
                                    'scope': '#/properties/pipeline/properties/interpolation/properties/samples/properties/type'
                                },
                                {
                                    'type': 'Control',
                                    'label': 'Traces interpolation type',
                                    'scope': '#/properties/pipeline/properties/interpolation/properties/traces/properties/type'
                                }
                            ]
                        }
                    ]
                },
                {
                    'type': 'Group',
                    'label': 'Normalization',
                    'elements': [
                        {
                            'type': 'HorizontalLayout',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Type',
                                    'scope': '#/properties/pipeline/properties/normalization/properties/type'
                                },
                                {
                                    'type': 'Control',
                                    'label': 'Scale',
                                    'scope': '#/properties/pipeline/properties/normalization/properties/scale',
                                    'options': {'slider': true}
                                }
                            ]
                        }
                    ]
                },
                {
                    'type': 'Group',
                    'label': 'Limits',
                    'elements': [
                        {
                            'type': 'HorizontalLayout',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Low',
                                    'scope': '#/properties/pipeline/properties/normalization/properties/limits/properties/low'
                                },
                                {
                                    'type': 'Control',
                                    'label': 'High',
                                    'scope': '#/properties/pipeline/properties/normalization/properties/limits/properties/high'
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        {
            'type': 'Category',
            'label': 'Rasterizer',
            'elements': [
                {
                    'type': 'Group',
                    'label': 'Plot type',
                    'elements': [
                        {
                            'type': 'HorizontalLayout',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Wiggle',
                                    'scope': '#/properties/pipeline/properties/plot/properties/type/properties/Wiggle'
                                },
                                {
                                    'type': 'Control',
                                    'label': 'Reversed',
                                    'scope': '#/properties/pipeline/properties/plot/properties/type/properties/Reversed'
                                }
                            ]
                        },
                        {
                            'type': 'HorizontalLayout',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Positive fill',
                                    'scope': '#/properties/pipeline/properties/plot/properties/type/properties/PositiveFill'
                                },
                                {
                                    'type': 'Control',
                                    'label': 'Negative fill',
                                    'scope': '#/properties/pipeline/properties/plot/properties/type/properties/NegativeFill'
                                }
                            ]
                        },
                        {
                            'type': 'HorizontalLayout',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Positive color fill',
                                    'scope': '#/properties/pipeline/properties/plot/properties/type/properties/PositiveColorFill'
                                },
                                {
                                    'type': 'Control',
                                    'label': 'Negative color fill',
                                    'scope': '#/properties/pipeline/properties/plot/properties/type/properties/NegativeColorFill'
                                }
                            ]
                        },
                        {
                            'type': 'HorizontalLayout',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Simple density',
                                    'scope': '#/properties/pipeline/properties/plot/properties/type/properties/SimpleDensity'
                                },
                                {
                                    'type': 'Control',
                                    'label': 'Interpolated density',
                                    'scope': '#/properties/pipeline/properties/plot/properties/type/properties/InterpolatedDensity'
                                }
                            ]
                        }
                    ]
                },
                {
                    'type': 'Group',
                    'label': 'Wiggle',
                    'elements': [
                        {
                            'type': 'HorizontalLayout',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Clipping factor',
                                    'scope': '#/properties/pipeline/properties/plot/properties/clippingFactor'
                                },
                                {
                                    'type': 'Control',
                                    'label': 'Decimation spacing',
                                    'scope': '#/properties/pipeline/properties/plot/properties/decimationSpacing'
                                }
                            ]
                        },
                        {
                            'type': 'Control',
                            'label': 'Density decimation',
                            'scope': '#/properties/pipeline/properties/plot/properties/densityDecimation'
                        }
                    ]
                },
                {
                    'type': 'Group',
                    'label': 'Colors',
                    'elements': [
                        {
                            'type': 'Control',
                            'label': 'Color map',
                            'scope': '#/properties/pipeline/properties/colors/properties/colorMap',
                            'options': {
                                'images': true,
                                'showLabels': true,
                                'items': colorMapItems
                            }
                        }
                    ]
                },
                {
                    'type': 'Group',
                    'label': 'Clipping',
                    'elements': [
                        {
                            'type': 'Control',
                            'label': 'Clipping Mode',
                            'scope': '#/properties/pipeline/properties/clippingmode'
                        }
                    ]
                }
            ]
        },
        {
            'type': 'Category',
            'label': 'Auxiliary Chart',
            'elements': [
                {
                    'type': 'VerticalLayout',
                    'elements': [
                        {
                            'type': 'Control',
                            'scope': '#/charts'
                        }
                    ]
                }
            ]
        },
        {
            'type': 'Category',
            'label': 'Header axis',
            'elements': [
                {
                    'type': 'VerticalLayout',
                    'elements': [
                        {
                            'type': 'Control',
                            'scope': '#/headers'
                        }
                    ]
                }
            ]
        },
        {
            'type': 'Category',
            'label': 'Processor',
            'rule': {
                'effect': 'SHOW',
                'condition': {
                    'scope': '#/isServerRendering',
                    'schema': {
                        'const': false
                    }
                }
            },
            'elements': [
                {
                    'type': 'Expanded',
                    'scope': '#/properties/pipeline/properties/processes',
                    'options': {
                        'draggable': true
                    },
                    'elements': [
                        {
                            'scope': '#/properties/TaperFilter',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Enabled',
                                    'scope': '#/properties/apply'
                                },
                                {
                                    'type': 'HorizontalLayout',
                                    'elements': [
                                        {
                                            'type': 'Control',
                                            'label': 'Freq01',
                                            'scope': '#/properties/f1'
                                        },
                                        {
                                            'type': 'Control',
                                            'label': 'Freq11',
                                            'scope': '#/properties/f2'
                                        }
                                    ]
                                },
                                {
                                    'type': 'HorizontalLayout',
                                    'elements': [
                                        {
                                            'type': 'Control',
                                            'label': 'Freq02',
                                            'scope': '#/properties/f3'
                                        },
                                        {
                                            'type': 'Control',
                                            'label': 'Freq22',
                                            'scope': '#/properties/f4'
                                        }
                                    ]
                                },
                                {
                                    'type': 'HorizontalLayout',
                                    'elements': [
                                        {
                                            'type': 'Control',
                                            'label': 'Sample rate',
                                            'scope': '#/properties/sampleRate'
                                        },
                                        {
                                            'type': 'Control',
                                            'label': 'Band-pass mode',
                                            'scope': '#/properties/passFlag'
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            'scope': '#/properties/AGC',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Enabled',
                                    'scope': '#/properties/apply'
                                },
                                {
                                    'type': 'HorizontalLayout',
                                    'elements': [
                                        {
                                            'type': 'Control',
                                            'label': 'AGC length',
                                            'scope': '#/properties/agcLength'
                                        },
                                        {
                                            'type': 'Control',
                                            'label': 'Desired average',
                                            'scope': '#/properties/desiredAverage'
                                        }
                                    ]
                                },
                                {
                                    'type': 'HorizontalLayout',
                                    'elements': [
                                        {
                                            'type': 'Control',
                                            'label': 'Noise reduction',
                                            'scope': '#/properties/noiseReduction'
                                        },
                                        {
                                            'type': 'Control',
                                            'label': 'Noise reduction percentage',
                                            'scope': '#/properties/noiseReductionPercentage'
                                        }
                                    ]
                                },
                                {
                                    'type': 'HorizontalLayout',
                                    'elements': [
                                        {
                                            'type': 'Control',
                                            'label': 'Start sample',
                                            'scope': '#/properties/startSample'
                                        },
                                        {
                                            'type': 'Control',
                                            'label': 'Step',
                                            'scope': '#/properties/step'
                                        }
                                    ]
                                },
                                {
                                    'type': 'HorizontalLayout',
                                    'elements': [
                                        {
                                            'type': 'Control',
                                            'label': 'Units',
                                            'scope': '#/properties/units'
                                        },
                                        {
                                            'type': 'Control',
                                            'label': 'Window length',
                                            'scope': '#/properties/windowLength'
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            'scope': '#/properties/Reverse',
                            'elements': [
                                {
                                    'type': 'Control',
                                    'label': 'Enabled',
                                    'scope': '#/properties/apply'
                                },
                                {
                                    'type': 'HorizontalLayout',
                                    'elements': [
                                        {
                                            'type': 'Control',
                                            'label': 'Inverted',
                                            'scope': '#/properties/inverted'
                                        },
                                        {
                                            'type': 'Control',
                                            'label': 'Reversed',
                                            'scope': '#/properties/reversed'
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }
            ]
        }
    ]
};
export {uischema};
