import request from '@/utils/request'

// 查询segy信息列表
export function listSegy(query) {
  return request({
    url: '/ysqqXmxxSegy/segy/list',
    method: 'get',
    params: query
  })
}

// 查询segy信息详细
export function getSegy(id) {
  return request({
    url: '/ysqqXmxxSegy/segy/' + id,
    method: 'get'
  })
}

// 新增segy信息
export function addSegy(data) {
  return request({
    url: '/ysqqXmxxSegy/segy',
    method: 'post',
    data: data
  })
}

// 修改segy信息
export function updateSegy(data) {
  return request({
    url: '/ysqqXmxxSegy/segy',
    method: 'put',
    data: data
  })
}

// 删除segy信息
export function delSegy(id) {
  return request({
    url: '/ysqqXmxxSegy/segy/' + id,
    method: 'delete'
  })
}
