import request from '@/utils/request'

// 查询资料类型列表
export function listZllx(query) {
  return request({
    url: '/yscgZllx/zllx/list',
    method: 'get',
    params: query,
  })
}

// 查询资料类型详细
export function getZllx(id) {
  return request({
    url: '/yscgZllx/zllx/' + id,
    method: 'get',
  })
}

// 新增资料类型
export function addZllx(data) {
  return request({
    url: '/yscgZllx/zllx',
    method: 'post',
    data: data,
  })
}

// 修改资料类型
export function updateZllx(data) {
  return request({
    url: '/yscgZllx/zllx',
    method: 'put',
    data: data,
  })
}

// 删除资料类型
export function delZllx(id) {
  return request({
    url: '/yscgZllx/zllx/' + id,
    method: 'delete',
  })
}

// 查询资料类型下拉选项
export function selectZllx() {
  return request({
    url: '/yscgZllx/zllx/selectZllx',
    method: 'get',
  })
}
