package com.seismic.model;

import lombok.Data;
import lombok.Builder;

@Data
@Builder
public class SeismicMetadata {
    private Dimensions dimensions;
    private Statistics statistics;
    private SampleInfo sampleInfo;

    @Data
    @Builder
    public static class Dimensions {
        private int traces;
        private int samples;
    }

    @Data
    @Builder
    public static class Statistics {
        private double min;
        private double max;
        private double rms;
    }

    @Data
    @Builder
    public static class SampleInfo {
        private double interval;
        private String format;
        private String unit;
    }
} 