import request from '@/utils/request'

// 查询会议纪要_附件列表
export function listFile(query) {
  return request({
    url: '/hyjyxxFile/file/list',
    method: 'get',
    params: query
  })
}

// 查询会议纪要_附件详细
export function getFile(id) {
  return request({
    url: '/hyjyxxFile/file/' + id,
    method: 'get'
  })
}

// 新增会议纪要_附件
export function addFile(data) {
  return request({
    url: '/hyjyxxFile/file',
    method: 'post',
    data: data
  })
}

// 修改会议纪要_附件
export function updateFile(data) {
  return request({
    url: '/hyjyxxFile/file',
    method: 'put',
    data: data
  })
}

// 删除会议纪要_附件
export function delFile(id) {
  return request({
    url: '/hyjyxxFile/file/' + id,
    method: 'delete'
  })
}
