import request from '@/utils/request'

// 查询会议模板列表
export function listHymb(query) {
  return request({
    url: '/hyjyxxMb/hymb/list',
    method: 'get',
    params: query
  })
}

// 查询会议模板详细
export function getHymb(id) {
  return request({
    url: '/hyjyxxMb/hymb/' + id,
    method: 'get'
  })
}

// 新增会议模板
export function addHymb(data) {
  return request({
    url: '/hyjyxxMb/hymb',
    method: 'post',
    data: data
  })
}

// 修改会议模板
export function updateHymb(data) {
  return request({
    url: '/hyjyxxMb/hymb',
    method: 'put',
    data: data
  })
}

// 删除会议模板
export function delHymb(id) {
  return request({
    url: '/hyjyxxMb/hymb/' + id,
    method: 'delete'
  })
}
