import request from '@/utils/request'

// 简单去重：相同 id 的详情请求在同一时刻仅发起一次
const inFlightDetailMap = new Map()

// 查询会议信息列表
export function listHyjyxx(query) {
  return request({
    url: '/hyjyxx/hyjyxx/list',
    method: 'get',
    params: query,
  })
}

// 查询会议信息详细
export function getHyjyxx(id) {
  const key = String(id)
  if (inFlightDetailMap.has(key)) {
    return inFlightDetailMap.get(key)
  }
  const p = request({
    url: '/hyjyxx/hyjyxx/hyxx/' + id,
    // url: "/hyjyxx/hyjyxx/" + id,
    method: 'get',
  }).finally(() => {
    // 请求结束后清理，允许后续新的刷新
    inFlightDetailMap.delete(key)
  })
  inFlightDetailMap.set(key, p)
  return p
}

// 新增会议信息
export function addHyjyxx(data) {
  return request({
    url: '/hyjyxx/hyjyxx',
    method: 'post',
    data: data,
  })
}

// 修改会议信息
export function updateHyjyxx(data) {
  return request({
    url: '/hyjyxx/hyjyxx',
    method: 'put',
    data: data,
  })
}

// 删除会议信息
export function delHyjyxx(id) {
  return request({
    url: '/hyjyxx/hyjyxx/' + id,
    method: 'delete',
  })
}
//下拉框
export function getHyjyxxAll() {
  return request({
    url: '/hyjyxxMb/hymb/selectHybm',
    method: 'get',
  })
}
// 开始转录
export function startConvert(id) {
  return request({
    url: `/hyjyxx/hyjyxx/hyzl/${id}`,
    method: 'post',
  })
}
// 导出Word（转录文本）
export function exportWordYY(id) {
  return request({
    url: '/hyjyxx/hyjyxx/exportWord_YY',
    method: 'post',
    data: { id },
  })
}
