import request from '@/utils/request'

// 查询验收前期-项目信息列表
export function listYsqqXmxx(query) {
  return request({
    url: '/ysqqXmxx/ysqqXmxx/list',
    method: 'get',
    params: query,
  })
}

// 查询验收前期-项目信息详细
export function getYsqqXmxx(id) {
  return request({
    url: '/ysqqXmxx/ysqqXmxx/' + id,
    method: 'get',
  })
}

// 新增验收前期-项目信息
export function addYsqqXmxx(data) {
  return request({
    url: '/ysqqXmxx/ysqqXmxx',
    method: 'post',
    data: data,
  })
}

// 修改验收前期-项目信息
export function updateYsqqXmxx(data) {
  return request({
    url: '/ysqqXmxx/ysqqXmxx',
    method: 'put',
    data: data,
  })
}

// 删除验收前期-项目信息
export function delYsqqXmxx(id) {
  return request({
    url: '/ysqqXmxx/ysqqXmxx/' + id,
    method: 'delete',
  })
}
//提交按钮
export function startConvert(id) {
  return request({
    url: '/ysqqXmxx/ysqqXmxx/toDys/' + id,
    method: 'post',
  })
}
//撤回按钮
export function withdraw(id) {
  return request({
    url: '/ysqqXmxx/ysqqXmxx/toWtj/' + id,
    method: 'post',
  })
}

export function toDht(id) {
  // 参数验证：确保 id 有效
  if (!id || id === 'null' || id === 'undefined' || String(id).trim() === '') {
    return Promise.reject(new Error('无效的ID参数'))
  }
  return request({
    url: '/ysqqXmxx/ysqqXmxx/dht/' + id,
    method: 'get',
  })
}
