import request from '@/utils/request'

// 查询分享管理列表
export function listFilerole(query) {
  return request({
    url: '/yscgFileRole/filerole/list',
    method: 'get',
    params: query,
  })
}

// 查询分享管理详细
export function getFilerole(id) {
  return request({
    url: '/yscgFileRole/filerole/' + id,
    method: 'get',
  })
}

// 新增分享管理
export function addFilerole(data) {
  return request({
    url: '/yscgFileRole/filerole',
    method: 'post',
    data: data,
  })
}

// 修改分享管理
export function updateFilerole(data) {
  return request({
    url: '/yscgFileRole/filerole',
    method: 'put',
    data: data,
  })
}

// 删除分享管理
export function delFilerole(id) {
  return request({
    url: '/yscgFileRole/filerole/' + id,
    method: 'delete',
  })
}

// 批量添加分享管理
export function batchYscgFileRole(fileid, userIds) {
  return request({
    url: '/yscgFileRole/filerole/batchYscgFileRole',
    method: 'put',
    params: { fileid, userIds },
  })
}
